<?php
/**
 * Binance P2P Notifications
 * View system notifications (low balance, errors, etc.)
 */

require_once '../includes/config.php';
require_once '../includes/functions.php';

require_login();

// Mark as read
if (isset($_GET['mark_read'])) {
    $id = intval($_GET['mark_read']);
    $stmt = $pdo->prepare("UPDATE binance_p2p_notifications SET is_read = 1 WHERE id = ?");
    $stmt->execute([$id]);
    header('Location: notifications.php');
    exit();
}

// Mark all as read
if (isset($_GET['mark_all_read'])) {
    $stmt = $pdo->prepare("UPDATE binance_p2p_notifications SET is_read = 1");
    $stmt->execute();
    header('Location: notifications.php');
    exit();
}

// Get notifications
$stmt = $pdo->prepare("
    SELECT * FROM binance_p2p_notifications 
    ORDER BY created_at DESC 
    LIMIT 100
");
$stmt->execute();
$notifications = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get unread count
$unreadStmt = $pdo->query("SELECT COUNT(*) as count FROM binance_p2p_notifications WHERE is_read = 0");
$unreadCount = $unreadStmt->fetch(PDO::FETCH_ASSOC)['count'];

$page_title = "Notifications";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .notification-item {
            padding: 15px;
            border-bottom: 1px solid #eee;
            transition: background-color 0.2s;
        }
        .notification-item:hover {
            background-color: #f8f9fa;
        }
        .notification-item.unread {
            background-color: #e7f3ff;
            border-left: 4px solid #667eea;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-dark">
        <div class="container-fluid">
            <span class="navbar-brand mb-0 h1">
                <i class="bi bi-bell"></i> Notifications
                <?php if ($unreadCount > 0): ?>
                    <span class="badge bg-danger"><?php echo $unreadCount; ?></span>
                <?php endif; ?>
            </span>
            <div>
                <?php if ($unreadCount > 0): ?>
                    <a href="?mark_all_read=1" class="btn btn-light btn-sm me-2">
                        <i class="bi bi-check-all"></i> Mark All Read
                    </a>
                <?php endif; ?>
                <a href="orders.php" class="btn btn-light btn-sm">
                    <i class="bi bi-arrow-left"></i> Back to Orders
                </a>
            </div>
        </div>
    </nav>

    <div class="container-fluid mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">System Notifications</h5>
            </div>
            <div class="card-body p-0">
                <?php if (empty($notifications)): ?>
                    <div class="text-center py-5 text-muted">
                        <i class="bi bi-inbox" style="font-size: 3rem;"></i>
                        <p class="mt-3">No notifications</p>
                    </div>
                <?php else: ?>
                    <?php foreach ($notifications as $notification): ?>
                        <div class="notification-item <?php echo !$notification['is_read'] ? 'unread' : ''; ?>">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1">
                                    <h6 class="mb-1">
                                        <?php if (!$notification['is_read']): ?>
                                            <span class="badge bg-primary me-2">New</span>
                                        <?php endif; ?>
                                        <?php echo sanitize($notification['title']); ?>
                                    </h6>
                                    <p class="mb-1 text-muted"><?php echo sanitize($notification['message']); ?></p>
                                    <small class="text-muted">
                                        <i class="bi bi-clock"></i> <?php echo format_date($notification['created_at']); ?>
                                        <?php if ($notification['order_no']): ?>
                                            | Order: <a href="order-details.php?order_no=<?php echo urlencode($notification['order_no']); ?>"><?php echo sanitize($notification['order_no']); ?></a>
                                        <?php endif; ?>
                                    </small>
                                </div>
                                <?php if (!$notification['is_read']): ?>
                                    <a href="?mark_read=<?php echo $notification['id']; ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-check"></i> Mark Read
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

